/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.expressions.impls.Expression;
import java.time.DayOfWeek;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class DateTruncExpression
extends Expression {
    private final Expression date;
    private final TimeUnit unit;
    private Expression timezone;
    private DayOfWeek startOfWeek;
    private Long binSize;

    public DateTruncExpression(Expression date, TimeUnit unit) {
        super("$dateTrunc");
        this.date = date;
        this.unit = unit;
    }

    public DateTruncExpression binSize(long binSize) {
        this.binSize = binSize;
        return this;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, "date", this.date, encoderContext);
            writer.writeString("unit", this.unit.name().toLowerCase(Locale.ROOT));
            if (this.binSize != null) {
                writer.writeInt64("binSize", this.binSize.longValue());
            }
            ExpressionHelper.expression(datastore, writer, "timezone", this.timezone, encoderContext);
            if (this.startOfWeek != null) {
                writer.writeString("startOfWeek", this.startOfWeek.name().toLowerCase(Locale.ROOT));
            }
        });
    }

    public DateTruncExpression startOfWeek(DayOfWeek startOfWeek) {
        this.startOfWeek = startOfWeek;
        return this;
    }

    public DateTruncExpression timezone(Expression timezone) {
        this.timezone = timezone;
        return this;
    }
}

