/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ExpMovingAvg
extends Expression {
    private final Expression input;
    private final Integer n;
    private final Double alpha;

    public ExpMovingAvg(Expression input, int n) {
        super("$expMovingAvg");
        this.input = input;
        this.n = n;
        this.alpha = null;
    }

    public ExpMovingAvg(Expression input, double alpha) {
        super("$expMovingAvg");
        this.input = input;
        this.n = null;
        this.alpha = alpha;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            writer.writeName("input");
            ExpressionHelper.expression(datastore, writer, this.input, encoderContext);
            if (this.n != null) {
                ExpressionHelper.value(writer, "N", this.n);
            } else {
                ExpressionHelper.value(datastore, writer, "alpha", this.alpha, encoderContext);
            }
        });
    }
}

