/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.ExpressionList;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.List;
import java.util.StringJoiner;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class Expression {
    private final String operation;
    private final Expression value;

    public Expression(String operation) {
        this.operation = operation;
        this.value = null;
    }

    @MorphiaInternal
    public Expression(String operation, Expression value) {
        this.operation = operation;
        this.value = value;
    }

    @MorphiaInternal
    public Expression(String operation, List<Expression> value) {
        this.operation = operation;
        this.value = new ExpressionList(value);
    }

    @MorphiaInternal
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.expression(datastore, writer, this.operation, this.value, encoderContext);
    }

    @MorphiaInternal
    public String getOperation() {
        return this.operation;
    }

    @Nullable
    @MorphiaInternal
    public Expression getValue() {
        return this.value;
    }

    public String toString() {
        return new StringJoiner(", ", Expression.class.getSimpleName() + "[", "]").add("operation='" + this.operation + "'").toString();
    }
}

