/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import com.mongodb.lang.NonNull;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.SingleValuedExpression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class ExpressionList
extends Expression
implements SingleValuedExpression {
    private final List<Expression> values;

    public ExpressionList(List<Expression> values) {
        super("unused");
        this.values = new ArrayList<Expression>(values);
    }

    public ExpressionList(Expression ... values) {
        super("unused");
        this.values = new ArrayList<Expression>(Arrays.asList(values));
    }

    @NonNull
    public static ExpressionList coalesce(Expression first, Expression ... values) {
        ExpressionList expressionList = new ExpressionList(first);
        expressionList.values.addAll(Arrays.asList(values));
        return expressionList;
    }

    public void add(Expression expression) {
        this.values.add(expression);
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.array(writer, () -> {
            for (Expression expression : this.values) {
                ExpressionHelper.wrapExpression(datastore, writer, expression, encoderContext);
            }
        });
    }

    @Override
    public Expression getValue() {
        throw new UnsupportedOperationException("should have called getValues() here");
    }

    @NonNull
    public List<Expression> getValues() {
        return this.values;
    }
}

