/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class FunctionExpression
extends Expression {
    private final String body;
    private final List<Expression> args;
    private final String lang = "js";

    @MorphiaInternal
    public FunctionExpression(String body, List<Expression> args) {
        super("$function");
        this.body = body;
        this.args = args;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            writer.writeString("body", this.body);
            ExpressionHelper.array(datastore, writer, "args", this.args, encoderContext);
            writer.writeString("lang", "js");
        });
    }
}

