/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class IndexExpression
extends Expression {
    private final Expression string;
    private final Expression substring;
    private Integer end;
    private Integer start;

    @MorphiaInternal
    public IndexExpression(String operation, Expression string, Expression substring) {
        super(operation);
        this.string = string;
        this.substring = substring;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.array(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, this.string, encoderContext);
            ExpressionHelper.expression(datastore, writer, this.substring, encoderContext);
            ExpressionHelper.value(datastore, writer, this.start, encoderContext);
            ExpressionHelper.value(datastore, writer, this.end, encoderContext);
        });
    }

    public IndexExpression end(int end) {
        this.end = end;
        return this;
    }

    public IndexExpression start(int start) {
        this.start = start;
        return this;
    }
}

