/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.ExpressionList;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class MathExpression
extends Expression {
    @MorphiaInternal
    public MathExpression(String operation, List<Expression> operands) {
        super(operation, new ExpressionList(operands));
    }

    @MorphiaInternal
    public MathExpression(String operation, Expression operand) {
        super(operation, new ExpressionList(operand));
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionList value = this.getValue();
        if (value != null) {
            List<Expression> operands = value.getValues();
            writer.writeName(this.getOperation());
            if (operands.size() > 1) {
                writer.writeStartArray();
            }
            for (Expression operand : operands) {
                if (operand != null) {
                    ExpressionHelper.wrapExpression(datastore, writer, operand, encoderContext);
                    continue;
                }
                writer.writeNull();
            }
            if (operands.size() > 1) {
                writer.writeEndArray();
            }
        }
    }

    @Override
    public ExpressionList getValue() {
        return (ExpressionList)super.getValue();
    }
}

