/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.query.Sort;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class NRankedResultsExpression
extends Expression {
    private final Expression output;
    private final Expression n;
    private final Sort[] sortBy;

    public NRankedResultsExpression(String operation, Expression n, Expression output, Sort ... sortBy) {
        super(operation);
        this.output = output;
        this.n = n;
        this.sortBy = sortBy;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, "output", this.output, encoderContext);
            if (this.sortBy.length == 1) {
                writer.writeName("sortBy");
                ExpressionHelper.encode(writer, this.sortBy[0]);
            } else {
                ExpressionHelper.array(writer, "sortBy", () -> {
                    for (Sort sort : this.sortBy) {
                        ExpressionHelper.encode(writer, sort);
                    }
                });
            }
            ExpressionHelper.expression(datastore, writer, "n", this.n, encoderContext);
        });
    }
}

