/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class PipelineField {
    private final String name;
    private final Expression value;

    public PipelineField(String name, Expression value) {
        this.name = name;
        this.value = value;
    }

    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeName(this.name);
        this.value.encode(datastore, writer, encoderContext);
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("PipelineField{name='%s', value=%s}", this.name, this.value);
    }
}

