/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.AggregationException;
import dev.morphia.aggregation.expressions.Expressions;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.FieldHolder;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class Push
extends Expression
implements FieldHolder<Push> {
    private Expression field;
    private DocumentExpression document;

    public Push() {
        super("$push");
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeName(this.getOperation());
        if (this.field != null) {
            this.field.encode(datastore, writer, encoderContext);
        } else if (this.document != null) {
            this.document.encode(datastore, writer, encoderContext);
        }
    }

    @Override
    public Push field(String name, Expression expression) {
        if (this.field != null) {
            throw new AggregationException(Sofia.mixedModesNotAllowed(this.getOperation(), new Locale[0]));
        }
        if (this.document == null) {
            this.document = Expressions.of();
        }
        this.document.field(name, expression);
        return this;
    }

    public Push single(Expression source) {
        if (this.document != null) {
            throw new AggregationException(Sofia.mixedModesNotAllowed(this.getOperation(), new Locale[0]));
        }
        this.field = source;
        return this;
    }
}

