/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class RangeExpression
extends Expression {
    private final int start;
    private final int end;
    private Integer step;

    public RangeExpression(int start, int end) {
        super("$range");
        this.start = start;
        this.end = end;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.array(writer, this.getOperation(), () -> {
            writer.writeInt32(this.start);
            writer.writeInt32(this.end);
            if (this.step != null) {
                writer.writeInt32(this.step.intValue());
            }
        });
    }

    public RangeExpression step(Integer step) {
        this.step = step;
        return this;
    }
}

