/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import java.util.regex.Pattern;
import org.bson.BsonRegularExpression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class RegexExpression
extends Expression {
    private final Expression input;
    private String regex;
    private String options;

    public RegexExpression(String operation, Expression input) {
        super(operation);
        this.input = input;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, "input", this.input, encoderContext);
            ExpressionHelper.value(datastore, writer, "regex", new BsonRegularExpression(this.regex), encoderContext);
            ExpressionHelper.value(writer, "options", this.options);
        });
    }

    public RegexExpression options(String options) {
        this.options = options;
        return this;
    }

    public RegexExpression pattern(String pattern) {
        this.regex = pattern;
        return this;
    }

    public RegexExpression pattern(Pattern pattern) {
        this.regex = pattern.pattern();
        return this;
    }
}

