/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class SliceExpression
extends Expression {
    private final Expression array;
    private final int size;
    private Integer position;

    public SliceExpression(Expression array, int size) {
        super("$slice");
        this.array = array;
        this.size = size;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.array(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, this.array, encoderContext);
            if (this.position != null) {
                writer.writeInt32(this.position.intValue());
            }
            writer.writeInt32(this.size);
        });
    }

    public SliceExpression position(Integer position) {
        this.position = position;
        return this;
    }
}

