/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class SwitchExpression
extends Expression {
    private final List<Pair> branches = new ArrayList<Pair>();
    private Expression defaultCase;

    @MorphiaInternal
    public SwitchExpression() {
        super("$switch");
    }

    public SwitchExpression branch(Expression caseExpression, Expression then) {
        this.branches.add(new Pair(caseExpression, then));
        return this;
    }

    public SwitchExpression defaultCase(Expression caseExpression) {
        this.defaultCase = caseExpression;
        return this;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.array(writer, "branches", () -> {
                for (Pair branch : this.branches) {
                    ExpressionHelper.document(writer, () -> {
                        ExpressionHelper.wrapExpression(datastore, writer, "case", branch.caseExpression, encoderContext);
                        ExpressionHelper.wrapExpression(datastore, writer, "then", branch.then, encoderContext);
                    });
                }
            });
            ExpressionHelper.expression(datastore, writer, "default", this.defaultCase, encoderContext);
        });
    }

    private static class Pair {
        private final Expression caseExpression;
        private final Expression then;

        Pair(Expression caseExpression, Expression then) {
            this.caseExpression = caseExpression;
            this.then = then;
        }
    }
}

