/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.ValueExpression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ZipExpression
extends Expression {
    private final List<Expression> inputs;
    private ValueExpression useLongestLength;
    private Expression defaults;

    @MorphiaInternal
    public ZipExpression(List<Expression> inputs) {
        super("$zip");
        this.inputs = inputs;
    }

    public ZipExpression defaults(Expression defaults) {
        this.defaults = defaults;
        return this;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.array(datastore, writer, "inputs", this.inputs, encoderContext);
            ExpressionHelper.expression(datastore, writer, "useLongestLength", this.useLongestLength, encoderContext);
            ExpressionHelper.expression(datastore, writer, "defaults", this.defaults, encoderContext);
        });
    }

    public ZipExpression useLongestLength(Boolean useLongestLength) {
        this.useLongestLength = new ValueExpression(useLongestLength);
        return this;
    }
}

