/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.stages;

import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Arrays;
import java.util.List;

public class Densify
extends Stage {
    private final String field;
    private final Range range;
    private List<String> partitionByFields;

    private Densify(String field, Range range) {
        super("$densify");
        this.field = field;
        this.range = range;
    }

    public static Densify densify(String field, Range range) {
        return new Densify(field, range);
    }

    @MorphiaInternal
    public String field() {
        return this.field;
    }

    public Densify partitionByFields(String ... partitionByFields) {
        this.partitionByFields = Arrays.asList(partitionByFields);
        return this;
    }

    @MorphiaInternal
    public List<String> partitionByFields() {
        return this.partitionByFields;
    }

    @MorphiaInternal
    public Range range() {
        return this.range;
    }

    public static class Range {
        private final RangeType type;
        private final Number step;
        private TimeUnit unit;
        private Object lowerBound;
        private Object upperBound;

        protected Range(RangeType type, Number step) {
            this.type = type;
            this.step = step;
        }

        public static Range bounded(Object lowerBound, Object upperBound, Number step) {
            return new Range(RangeType.BOUNDED, step).bounds(lowerBound, upperBound);
        }

        private Range bounds(Object lowerBound, Object upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            return this;
        }

        public static Range full(Number step) {
            return new Range(RangeType.FULL, step);
        }

        public static Range partition(Number step) {
            return new Range(RangeType.PARTITION, step);
        }

        @MorphiaInternal
        public Object lowerBound() {
            return this.lowerBound;
        }

        @MorphiaInternal
        public Number step() {
            return this.step;
        }

        @MorphiaInternal
        public RangeType type() {
            return this.type;
        }

        @MorphiaInternal
        public TimeUnit unit() {
            return this.unit;
        }

        public Range unit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        @MorphiaInternal
        public Object upperBound() {
            return this.upperBound;
        }
    }

    @MorphiaInternal
    public static enum RangeType {
        BOUNDED,
        FULL,
        PARTITION;

    }
}

