/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.stages;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.ValueExpression;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.query.Sort;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Fill
extends Stage {
    private final Map<String, Object> fields = new LinkedHashMap<String, Object>();
    private Expression partitionBy;
    private List<String> partitionByFields;
    private Sort[] sortBy;

    protected Fill() {
        super("$fill");
    }

    public static Fill fill() {
        return new Fill();
    }

    public Fill field(String name, ValueExpression value) {
        this.fields.put(name, value);
        return this;
    }

    public Fill field(String name, Method method) {
        this.fields.put(name, (Object)method);
        return this;
    }

    @MorphiaInternal
    public Map<String, Object> fields() {
        return this.fields;
    }

    public Fill partitionBy(Expression partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    @Nullable
    @MorphiaInternal
    public Expression partitionBy() {
        return this.partitionBy;
    }

    public Fill partitionByFields(String ... fields) {
        this.partitionByFields = Arrays.asList(fields);
        return this;
    }

    @Nullable
    @MorphiaInternal
    public List<String> partitionByFields() {
        return this.partitionByFields;
    }

    public Fill sortBy(Sort ... sorts) {
        this.sortBy = sorts;
        return this;
    }

    @Nullable
    @MorphiaInternal
    public Sort[] sortBy() {
        return this.sortBy;
    }

    public static enum Method {
        LINEAR,
        LOCF;

    }
}

