/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.stages;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.AggregationException;
import dev.morphia.aggregation.expressions.Expressions;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.Fields;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.sofia.Sofia;
import java.util.Locale;

public class Group
extends Stage {
    private final GroupId id;
    private Fields<Group> fields;

    protected Group() {
        super("$group");
        this.id = null;
    }

    protected Group(GroupId id) {
        super("$group");
        this.id = id;
    }

    public static Group group(GroupId id) {
        return new Group(id);
    }

    public static Group group() {
        return new Group();
    }

    public static GroupId id() {
        return new GroupId();
    }

    public static GroupId id(String name) {
        return new GroupId(Expressions.field(name));
    }

    public static GroupId id(Expression name) {
        return new GroupId(name);
    }

    @Deprecated(forRemoval=true)
    public static Group of(GroupId id) {
        return new Group(id);
    }

    @Deprecated(forRemoval=true)
    public static Group of() {
        return new Group();
    }

    public Group field(String name) {
        return this.field(name, Expressions.field(name));
    }

    public Group field(String name, Expression expression) {
        if (this.fields == null) {
            this.fields = Fields.on(this);
        }
        this.fields.add(name, expression);
        return this;
    }

    @Nullable
    @MorphiaInternal
    public Fields<Group> getFields() {
        return this.fields;
    }

    @Nullable
    @MorphiaInternal
    public GroupId getId() {
        return this.id;
    }

    public static class GroupId {
        private Expression field;
        private DocumentExpression document;

        protected GroupId() {
            this.document = Expressions.of();
        }

        protected GroupId(Expression value) {
            if (value instanceof DocumentExpression) {
                this.document = (DocumentExpression)value;
            } else {
                this.field = value;
            }
        }

        public GroupId field(String name) {
            return this.field(name, Expressions.field(name));
        }

        public GroupId field(String name, Expression expression) {
            if (this.field != null) {
                throw new AggregationException(Sofia.mixedModesNotAllowed("_id", new Locale[0]));
            }
            this.document.field(name, expression);
            return this;
        }

        @Nullable
        @MorphiaInternal
        public DocumentExpression getDocument() {
            return this.document;
        }

        @Nullable
        @MorphiaInternal
        public Expression getField() {
            return this.field;
        }
    }
}

