/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.stages;

import com.mongodb.client.model.MergeOptions;
import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Merge<M>
extends Stage {
    private Class<M> type;
    private String database;
    private String collection;
    private List<String> on;
    private Map<String, Expression> variables;
    private MergeOptions.WhenMatched whenMatched;
    private List<Stage> whenMatchedPipeline;
    private MergeOptions.WhenNotMatched whenNotMatched;

    protected Merge(Class<M> type) {
        this();
        this.type = type;
    }

    protected Merge() {
        super("$merge");
    }

    protected Merge(String collection) {
        this();
        this.collection = collection;
    }

    protected Merge(String database, String collection) {
        this();
        this.database = database;
        this.collection = collection;
    }

    public static <M> Merge<M> into(Class<M> type) {
        return new Merge<M>(type);
    }

    public static Merge<?> into(String collection) {
        return new Merge(collection);
    }

    public static Merge<?> into(String database, String collection) {
        return new Merge(database, collection);
    }

    @MorphiaInternal
    public String getCollection() {
        return this.collection;
    }

    @Nullable
    @MorphiaInternal
    public String getDatabase() {
        return this.database;
    }

    @MorphiaInternal
    public List<String> getOn() {
        return this.on;
    }

    @Nullable
    @MorphiaInternal
    public Class<M> getType() {
        return this.type;
    }

    @MorphiaInternal
    public Map<String, Expression> getVariables() {
        return this.variables;
    }

    @MorphiaInternal
    public MergeOptions.WhenMatched getWhenMatched() {
        return this.whenMatched;
    }

    @MorphiaInternal
    public List<Stage> getWhenMatchedPipeline() {
        return this.whenMatchedPipeline;
    }

    @MorphiaInternal
    public MergeOptions.WhenNotMatched getWhenNotMatched() {
        return this.whenNotMatched;
    }

    public Merge<M> let(String variable, Expression value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Expression>();
        }
        this.variables.put(variable, value);
        return this;
    }

    public Merge<M> on(String field, String ... fields) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(field);
        list.addAll(Arrays.asList(fields));
        this.on = list;
        return this;
    }

    public Merge<M> whenMatched(MergeOptions.WhenMatched whenMatched) {
        this.whenMatched = whenMatched;
        return this;
    }

    public Merge<M> whenMatched(List<Stage> pipeline) {
        this.whenMatchedPipeline = Collections.unmodifiableList(pipeline);
        return this;
    }

    public Merge<M> whenNotMatched(MergeOptions.WhenNotMatched whenNotMatched) {
        this.whenNotMatched = whenNotMatched;
        return this;
    }
}

