/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.stages;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.query.Sort;
import java.util.List;

public class SetWindowFields
extends Stage {
    private Expression partition;
    private Sort[] sorts;
    private Output[] outputs;

    protected SetWindowFields() {
        super("$setWindowFields");
    }

    public static SetWindowFields setWindowFields() {
        return new SetWindowFields();
    }

    public SetWindowFields output(Output ... outputs) {
        this.outputs = outputs;
        return this;
    }

    @MorphiaInternal
    public Output[] outputs() {
        return this.outputs;
    }

    @Nullable
    @MorphiaInternal
    public Expression partition() {
        return this.partition;
    }

    public SetWindowFields partitionBy(Expression partition) {
        this.partition = partition;
        return this;
    }

    public SetWindowFields sortBy(Sort ... sorts) {
        this.sorts = sorts;
        return this;
    }

    @Nullable
    @MorphiaInternal
    public Sort[] sorts() {
        return this.sorts;
    }

    public static class Window {
        private final Output output;
        private List<Object> documents;
        private List<Object> range;
        private TimeUnit unit;

        private Window(Output output) {
            this.output = output;
        }

        public Output documents(Object lower, Object upper) {
            this.documents = List.of(lower, upper);
            return this.output;
        }

        @Nullable
        @MorphiaInternal
        public List<Object> documents() {
            return this.documents;
        }

        public Output range(Object lower, Object upper, TimeUnit unit) {
            this.range = List.of(lower, upper);
            this.unit = unit;
            return this.output;
        }

        public Output range(Object lower, Object upper) {
            this.range = List.of(lower, upper);
            return this.output;
        }

        @Nullable
        @MorphiaInternal
        public List<Object> range() {
            return this.range;
        }

        @Nullable
        @MorphiaInternal
        public TimeUnit unit() {
            return this.unit;
        }
    }

    public static class Output {
        private final String name;
        private Expression operator;
        private Window window;

        private Output(String name) {
            this.name = name;
        }

        public static Output output(String name) {
            return new Output(name);
        }

        @MorphiaInternal
        public String name() {
            return this.name;
        }

        @Nullable
        @MorphiaInternal
        public Expression operator() {
            return this.operator;
        }

        public Output operator(Expression operator) {
            this.operator = operator;
            return this;
        }

        public Window window() {
            this.window = new Window(this);
            return this.window;
        }

        @Nullable
        @MorphiaInternal
        public Window windowDef() {
            return this.window;
        }
    }
}

