/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.CappedAt;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class CappedAtBuilder {
    private CappedAtAnnotation annotation = new CappedAtAnnotation();

    private CappedAtBuilder() {
        this.annotation.count = 0L;
        this.annotation.value = 0x100000L;
    }

    public CappedAt build() {
        CappedAtAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static CappedAtBuilder cappedAtBuilder() {
        return new CappedAtBuilder();
    }

    public static CappedAtBuilder cappedAtBuilder(CappedAt source) {
        CappedAtBuilder builder = new CappedAtBuilder();
        builder.annotation.count = source.count();
        builder.annotation.value = source.value();
        return builder;
    }

    public CappedAtBuilder count(long count) {
        this.annotation.count = count;
        return this;
    }

    public CappedAtBuilder value(long value) {
        this.annotation.value = value;
        return this;
    }

    private static class CappedAtAnnotation
    implements CappedAt {
        private long count;
        private long value;

        private CappedAtAnnotation() {
        }

        public Class<CappedAt> annotationType() {
            return CappedAt.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CappedAtAnnotation)) {
                return false;
            }
            CappedAtAnnotation that = (CappedAtAnnotation)o;
            return Objects.equals(this.count, that.count) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.count, this.value);
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long value() {
            return this.value;
        }
    }
}

