/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import dev.morphia.annotations.Collation;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class CollationBuilder {
    private CollationAnnotation annotation = new CollationAnnotation();

    private CollationBuilder() {
        this.annotation.backwards = false;
        this.annotation.caseLevel = false;
        this.annotation.locale = "";
        this.annotation.normalization = false;
        this.annotation.numericOrdering = false;
        this.annotation.alternate = CollationAlternate.NON_IGNORABLE;
        this.annotation.caseFirst = CollationCaseFirst.OFF;
        this.annotation.maxVariable = CollationMaxVariable.PUNCT;
        this.annotation.strength = CollationStrength.TERTIARY;
    }

    public Collation build() {
        CollationAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static CollationBuilder collationBuilder() {
        return new CollationBuilder();
    }

    public static CollationBuilder collationBuilder(Collation source) {
        CollationBuilder builder = new CollationBuilder();
        builder.annotation.backwards = source.backwards();
        builder.annotation.caseLevel = source.caseLevel();
        builder.annotation.locale = source.locale();
        builder.annotation.normalization = source.normalization();
        builder.annotation.numericOrdering = source.numericOrdering();
        builder.annotation.alternate = source.alternate();
        builder.annotation.caseFirst = source.caseFirst();
        builder.annotation.maxVariable = source.maxVariable();
        builder.annotation.strength = source.strength();
        return builder;
    }

    public CollationBuilder backwards(boolean backwards) {
        this.annotation.backwards = backwards;
        return this;
    }

    public CollationBuilder caseLevel(boolean caseLevel) {
        this.annotation.caseLevel = caseLevel;
        return this;
    }

    public CollationBuilder locale(String locale) {
        this.annotation.locale = locale;
        return this;
    }

    public CollationBuilder normalization(boolean normalization) {
        this.annotation.normalization = normalization;
        return this;
    }

    public CollationBuilder numericOrdering(boolean numericOrdering) {
        this.annotation.numericOrdering = numericOrdering;
        return this;
    }

    public CollationBuilder alternate(CollationAlternate alternate) {
        this.annotation.alternate = alternate;
        return this;
    }

    public CollationBuilder caseFirst(CollationCaseFirst caseFirst) {
        this.annotation.caseFirst = caseFirst;
        return this;
    }

    public CollationBuilder maxVariable(CollationMaxVariable maxVariable) {
        this.annotation.maxVariable = maxVariable;
        return this;
    }

    public CollationBuilder strength(CollationStrength strength) {
        this.annotation.strength = strength;
        return this;
    }

    private static class CollationAnnotation
    implements Collation {
        private boolean backwards;
        private boolean caseLevel;
        private String locale;
        private boolean normalization;
        private boolean numericOrdering;
        private CollationAlternate alternate;
        private CollationCaseFirst caseFirst;
        private CollationMaxVariable maxVariable;
        private CollationStrength strength;

        private CollationAnnotation() {
        }

        public Class<Collation> annotationType() {
            return Collation.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CollationAnnotation)) {
                return false;
            }
            CollationAnnotation that = (CollationAnnotation)o;
            return Objects.equals(this.backwards, that.backwards) && Objects.equals(this.caseLevel, that.caseLevel) && Objects.equals(this.locale, that.locale) && Objects.equals(this.normalization, that.normalization) && Objects.equals(this.numericOrdering, that.numericOrdering) && Objects.equals(this.alternate, that.alternate) && Objects.equals(this.caseFirst, that.caseFirst) && Objects.equals(this.maxVariable, that.maxVariable) && Objects.equals(this.strength, that.strength);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.backwards, this.caseLevel, this.locale, this.normalization, this.numericOrdering, this.alternate, this.caseFirst, this.maxVariable, this.strength);
        }

        @Override
        public boolean backwards() {
            return this.backwards;
        }

        @Override
        public boolean caseLevel() {
            return this.caseLevel;
        }

        @Override
        public String locale() {
            return this.locale;
        }

        @Override
        public boolean normalization() {
            return this.normalization;
        }

        @Override
        public boolean numericOrdering() {
            return this.numericOrdering;
        }

        @Override
        public CollationAlternate alternate() {
            return this.alternate;
        }

        @Override
        public CollationCaseFirst caseFirst() {
            return this.caseFirst;
        }

        @Override
        public CollationMaxVariable maxVariable() {
            return this.maxVariable;
        }

        @Override
        public CollationStrength strength() {
            return this.strength;
        }
    }
}

