/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.CappedAt;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.internal.CappedAtBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class EntityBuilder {
    private EntityAnnotation annotation = new EntityAnnotation();

    private EntityBuilder() {
        this.annotation.cap = CappedAtBuilder.cappedAtBuilder().build();
        this.annotation.concern = "";
        this.annotation.discriminator = ".";
        this.annotation.discriminatorKey = ".";
        this.annotation.useDiscriminator = true;
        this.annotation.value = ".";
    }

    public Entity build() {
        EntityAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static EntityBuilder entityBuilder() {
        return new EntityBuilder();
    }

    public static EntityBuilder entityBuilder(Entity source) {
        EntityBuilder builder = new EntityBuilder();
        builder.annotation.cap = source.cap();
        builder.annotation.concern = source.concern();
        builder.annotation.discriminator = source.discriminator();
        builder.annotation.discriminatorKey = source.discriminatorKey();
        builder.annotation.useDiscriminator = source.useDiscriminator();
        builder.annotation.value = source.value();
        return builder;
    }

    public EntityBuilder cap(CappedAt cap) {
        this.annotation.cap = cap;
        return this;
    }

    public EntityBuilder concern(String concern) {
        this.annotation.concern = concern;
        return this;
    }

    public EntityBuilder discriminator(String discriminator) {
        this.annotation.discriminator = discriminator;
        return this;
    }

    public EntityBuilder discriminatorKey(String discriminatorKey) {
        this.annotation.discriminatorKey = discriminatorKey;
        return this;
    }

    public EntityBuilder useDiscriminator(boolean useDiscriminator) {
        this.annotation.useDiscriminator = useDiscriminator;
        return this;
    }

    public EntityBuilder value(String value) {
        this.annotation.value = value;
        return this;
    }

    private static class EntityAnnotation
    implements Entity {
        private CappedAt cap;
        private String concern;
        private String discriminator;
        private String discriminatorKey;
        private boolean useDiscriminator;
        private String value;

        private EntityAnnotation() {
        }

        public Class<Entity> annotationType() {
            return Entity.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntityAnnotation)) {
                return false;
            }
            EntityAnnotation that = (EntityAnnotation)o;
            return Objects.equals(this.cap, that.cap) && Objects.equals(this.concern, that.concern) && Objects.equals(this.discriminator, that.discriminator) && Objects.equals(this.discriminatorKey, that.discriminatorKey) && Objects.equals(this.useDiscriminator, that.useDiscriminator) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.cap, this.concern, this.discriminator, this.discriminatorKey, this.useDiscriminator, this.value);
        }

        @Override
        public CappedAt cap() {
            return this.cap;
        }

        @Override
        public String concern() {
            return this.concern;
        }

        @Override
        public String discriminator() {
            return this.discriminator;
        }

        @Override
        public String discriminatorKey() {
            return this.discriminatorKey;
        }

        @Override
        public boolean useDiscriminator() {
            return this.useDiscriminator;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

