/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.Field;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.utils.IndexType;
import java.util.Objects;

@MorphiaInternal
public final class FieldBuilder {
    private FieldAnnotation annotation = new FieldAnnotation();

    private FieldBuilder() {
        this.annotation.type = IndexType.ASC;
        this.annotation.weight = -1;
    }

    public Field build() {
        FieldAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static FieldBuilder fieldBuilder() {
        return new FieldBuilder();
    }

    public static FieldBuilder fieldBuilder(Field source) {
        FieldBuilder builder = new FieldBuilder();
        builder.annotation.type = source.type();
        builder.annotation.value = source.value();
        builder.annotation.weight = source.weight();
        return builder;
    }

    public FieldBuilder type(IndexType type) {
        this.annotation.type = type;
        return this;
    }

    public FieldBuilder value(String value) {
        this.annotation.value = value;
        return this;
    }

    public FieldBuilder weight(int weight) {
        this.annotation.weight = weight;
        return this;
    }

    private static class FieldAnnotation
    implements Field {
        private IndexType type;
        private String value;
        private int weight;

        private FieldAnnotation() {
        }

        public Class<Field> annotationType() {
            return Field.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldAnnotation)) {
                return false;
            }
            FieldAnnotation that = (FieldAnnotation)o;
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.value, that.value) && Objects.equals(this.weight, that.weight);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value, this.weight});
        }

        @Override
        public IndexType type() {
            return this.type;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public int weight() {
            return this.weight;
        }
    }
}

