/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.Field;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.internal.IndexOptionsBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Arrays;
import java.util.Objects;

@MorphiaInternal
public final class IndexBuilder {
    private IndexAnnotation annotation = new IndexAnnotation();

    private IndexBuilder() {
        this.annotation.fields = new Field[0];
        this.annotation.options = IndexOptionsBuilder.indexOptionsBuilder().build();
    }

    public Index build() {
        IndexAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static IndexBuilder indexBuilder() {
        return new IndexBuilder();
    }

    public static IndexBuilder indexBuilder(Index source) {
        IndexBuilder builder = new IndexBuilder();
        builder.annotation.fields = source.fields();
        builder.annotation.options = source.options();
        return builder;
    }

    public IndexBuilder fields(Field ... fields) {
        this.annotation.fields = fields;
        return this;
    }

    public IndexBuilder options(IndexOptions options) {
        this.annotation.options = options;
        return this;
    }

    private static class IndexAnnotation
    implements Index {
        private Field[] fields;
        private IndexOptions options;

        private IndexAnnotation() {
        }

        public Class<Index> annotationType() {
            return Index.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexAnnotation)) {
                return false;
            }
            IndexAnnotation that = (IndexAnnotation)o;
            return Arrays.equals(this.fields, that.fields) && Objects.equals(this.options, that.options);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.fields, this.options);
        }

        @Override
        public Field[] fields() {
            return this.fields;
        }

        @Override
        public IndexOptions options() {
            return this.options;
        }
    }
}

