/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import com.mongodb.client.MongoCollection;
import com.mongodb.lang.Nullable;
import dev.morphia.annotations.Collation;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Indexes;
import dev.morphia.annotations.Text;
import dev.morphia.annotations.internal.FieldBuilder;
import dev.morphia.annotations.internal.IndexBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.sofia.Sofia;
import dev.morphia.utils.IndexType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public final class IndexHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IndexHelper.class);
    private final Mapper mapper;

    @MorphiaInternal
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public IndexHelper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Document calculateKeys(EntityModel entityModel, Index index) {
        Document keys = new Document();
        for (Field field : index.fields()) {
            String path;
            try {
                path = this.findField(entityModel, index.options(), field.value());
            }
            catch (Exception e) {
                path = field.value();
                if (!index.options().disableValidation()) {
                    throw new MappingException(Sofia.invalidIndexPath(path, entityModel.getType().getName(), new Locale[0]));
                }
                LOG.warn(Sofia.invalidIndexPath(path, entityModel.getType().getName(), new Locale[0]));
            }
            keys.putAll((Map)new Document(path, field.type().toIndexValue()));
        }
        return keys;
    }

    @Nullable
    public Index convert(@Nullable Text text, String nameToStore) {
        return text == null ? null : IndexBuilder.indexBuilder().options(text.options()).fields(FieldBuilder.fieldBuilder().value(nameToStore).type(IndexType.TEXT).weight(text.value()).build()).build();
    }

    @Nullable
    public Index convert(@Nullable Indexed indexed, String nameToStore) {
        return indexed == null ? null : IndexBuilder.indexBuilder().options(indexed.options()).fields(FieldBuilder.fieldBuilder().value(nameToStore).type(IndexType.fromValue(indexed.value().toIndexValue())).build()).build();
    }

    public com.mongodb.client.model.IndexOptions convert(IndexOptions options) {
        com.mongodb.client.model.IndexOptions indexOptions = new com.mongodb.client.model.IndexOptions().background(options.background()).sparse(options.sparse()).unique(options.unique());
        if (!options.language().equals("")) {
            indexOptions.defaultLanguage(options.language());
        }
        if (!options.languageOverride().equals("")) {
            indexOptions.languageOverride(options.languageOverride());
        }
        if (!options.name().equals("")) {
            indexOptions.name(options.name());
        }
        if (options.expireAfterSeconds() != -1) {
            indexOptions.expireAfter(Long.valueOf(options.expireAfterSeconds()), TimeUnit.SECONDS);
        }
        if (!options.partialFilter().equals("")) {
            indexOptions.partialFilterExpression((Bson)Document.parse((String)options.partialFilter()));
        }
        indexOptions.collation(this.convert(options.collation()));
        return indexOptions;
    }

    @Nullable
    public com.mongodb.client.model.Collation convert(Collation collation) {
        if (!collation.locale().equals("")) {
            return com.mongodb.client.model.Collation.builder().locale(collation.locale().equals("<default>") ? Locale.getDefault().toString() : collation.locale()).backwards(Boolean.valueOf(collation.backwards())).caseLevel(Boolean.valueOf(collation.caseLevel())).collationAlternate(collation.alternate()).collationCaseFirst(collation.caseFirst()).collationMaxVariable(collation.maxVariable()).collationStrength(collation.strength()).normalization(Boolean.valueOf(collation.normalization())).numericOrdering(Boolean.valueOf(collation.numericOrdering())).build();
        }
        return null;
    }

    @MorphiaInternal
    public void createIndex(MongoCollection<?> collection, EntityModel model) {
        if (!model.isInterface() && !model.isAbstract()) {
            for (Index index : this.collectIndexes(model, Collections.emptyList())) {
                this.createIndex(collection, model, index);
            }
        }
    }

    public void createIndex(MongoCollection<?> collection, EntityModel entityModel, Index index) {
        Document keys = this.calculateKeys(entityModel, index);
        com.mongodb.client.model.IndexOptions indexOptions = this.convert(index.options());
        this.calculateWeights(index, indexOptions);
        collection.createIndex((Bson)keys, indexOptions);
    }

    public String findField(EntityModel entityModel, IndexOptions options, String path) {
        if (path.equals("$**")) {
            return path;
        }
        return new PathTarget(this.mapper, entityModel, path, !options.disableValidation()).translatedPath();
    }

    private void calculateWeights(Index index, com.mongodb.client.model.IndexOptions indexOptions) {
        Document weights = new Document();
        for (Field field : index.fields()) {
            if (field.weight() == -1) continue;
            if (field.type() != IndexType.TEXT) {
                throw new MappingException("Weight values only apply to text indexes: " + Arrays.toString(index.fields()));
            }
            weights.put(field.value(), (Object)field.weight());
        }
        if (!weights.isEmpty()) {
            indexOptions.weights((Bson)weights);
        }
    }

    private List<Index> collectFieldIndexes(EntityModel entityModel) {
        List<Index> list = entityModel.getProperties(Indexed.class).stream().map(field -> this.convert(field.getAnnotation(Indexed.class), field.getMappedName())).collect(Collectors.toList());
        list.addAll(entityModel.getProperties(Text.class).stream().map(field -> this.convert(field.getAnnotation(Text.class), field.getMappedName())).collect(Collectors.toList()));
        return list;
    }

    private List<Index> collectIndexes(EntityModel entityModel, List<EntityModel> parentModels) {
        if (parentModels.contains(entityModel) || entityModel.getEmbeddedAnnotation() != null && parentModels.isEmpty()) {
            return Collections.emptyList();
        }
        List<Index> indexes = this.collectTopLevelIndexes(entityModel);
        indexes.addAll(this.collectFieldIndexes(entityModel));
        return indexes;
    }

    private List<Index> collectTopLevelIndexes(EntityModel entityModel) {
        EntityModel superClass;
        ArrayList<Index> list = new ArrayList<Index>();
        Indexes indexes = entityModel.getAnnotation(Indexes.class);
        if (indexes != null) {
            for (Index index : indexes.value()) {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Field field : index.fields()) {
                    fields.add(FieldBuilder.fieldBuilder().value(this.findField(entityModel, index.options(), field.value())).type(field.type()).weight(field.weight()).build());
                }
                list.add(this.replaceFields(index, fields));
            }
        }
        if ((superClass = entityModel.getSuperClass()) != null) {
            list.addAll(this.collectTopLevelIndexes(superClass));
        }
        return list;
    }

    private Index replaceFields(Index original, List<Field> list) {
        return IndexBuilder.indexBuilder(original).fields(list.toArray(new Field[0])).build();
    }
}

