/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.Collation;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.internal.CollationBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class IndexOptionsBuilder {
    private IndexOptionsAnnotation annotation = new IndexOptionsAnnotation();

    private IndexOptionsBuilder() {
        this.annotation.background = false;
        this.annotation.disableValidation = false;
        this.annotation.expireAfterSeconds = -1;
        this.annotation.language = "";
        this.annotation.languageOverride = "";
        this.annotation.name = "";
        this.annotation.sparse = false;
        this.annotation.unique = false;
        this.annotation.partialFilter = "";
        this.annotation.collation = CollationBuilder.collationBuilder().build();
    }

    public IndexOptions build() {
        IndexOptionsAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static IndexOptionsBuilder indexOptionsBuilder() {
        return new IndexOptionsBuilder();
    }

    public static IndexOptionsBuilder indexOptionsBuilder(IndexOptions source) {
        IndexOptionsBuilder builder = new IndexOptionsBuilder();
        builder.annotation.background = source.background();
        builder.annotation.disableValidation = source.disableValidation();
        builder.annotation.expireAfterSeconds = source.expireAfterSeconds();
        builder.annotation.language = source.language();
        builder.annotation.languageOverride = source.languageOverride();
        builder.annotation.name = source.name();
        builder.annotation.sparse = source.sparse();
        builder.annotation.unique = source.unique();
        builder.annotation.partialFilter = source.partialFilter();
        builder.annotation.collation = source.collation();
        return builder;
    }

    public IndexOptionsBuilder background(boolean background) {
        this.annotation.background = background;
        return this;
    }

    public IndexOptionsBuilder disableValidation(boolean disableValidation) {
        this.annotation.disableValidation = disableValidation;
        return this;
    }

    public IndexOptionsBuilder expireAfterSeconds(int expireAfterSeconds) {
        this.annotation.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public IndexOptionsBuilder language(String language) {
        this.annotation.language = language;
        return this;
    }

    public IndexOptionsBuilder languageOverride(String languageOverride) {
        this.annotation.languageOverride = languageOverride;
        return this;
    }

    public IndexOptionsBuilder name(String name) {
        this.annotation.name = name;
        return this;
    }

    public IndexOptionsBuilder sparse(boolean sparse) {
        this.annotation.sparse = sparse;
        return this;
    }

    public IndexOptionsBuilder unique(boolean unique) {
        this.annotation.unique = unique;
        return this;
    }

    public IndexOptionsBuilder partialFilter(String partialFilter) {
        this.annotation.partialFilter = partialFilter;
        return this;
    }

    public IndexOptionsBuilder collation(Collation collation) {
        this.annotation.collation = collation;
        return this;
    }

    private static class IndexOptionsAnnotation
    implements IndexOptions {
        private boolean background;
        private boolean disableValidation;
        private int expireAfterSeconds;
        private String language;
        private String languageOverride;
        private String name;
        private boolean sparse;
        private boolean unique;
        private String partialFilter;
        private Collation collation;

        private IndexOptionsAnnotation() {
        }

        public Class<IndexOptions> annotationType() {
            return IndexOptions.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexOptionsAnnotation)) {
                return false;
            }
            IndexOptionsAnnotation that = (IndexOptionsAnnotation)o;
            return Objects.equals(this.background, that.background) && Objects.equals(this.disableValidation, that.disableValidation) && Objects.equals(this.expireAfterSeconds, that.expireAfterSeconds) && Objects.equals(this.language, that.language) && Objects.equals(this.languageOverride, that.languageOverride) && Objects.equals(this.name, that.name) && Objects.equals(this.sparse, that.sparse) && Objects.equals(this.unique, that.unique) && Objects.equals(this.partialFilter, that.partialFilter) && Objects.equals(this.collation, that.collation);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.background, this.disableValidation, this.expireAfterSeconds, this.language, this.languageOverride, this.name, this.sparse, this.unique, this.partialFilter, this.collation);
        }

        @Override
        public boolean background() {
            return this.background;
        }

        @Override
        public boolean disableValidation() {
            return this.disableValidation;
        }

        @Override
        public int expireAfterSeconds() {
            return this.expireAfterSeconds;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String languageOverride() {
            return this.languageOverride;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean sparse() {
            return this.sparse;
        }

        @Override
        public boolean unique() {
            return this.unique;
        }

        @Override
        public String partialFilter() {
            return this.partialFilter;
        }

        @Override
        public Collation collation() {
            return this.collation;
        }
    }
}

