/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.internal.IndexOptionsBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.utils.IndexDirection;
import java.util.Objects;

@MorphiaInternal
public final class IndexedBuilder {
    private IndexedAnnotation annotation = new IndexedAnnotation();

    private IndexedBuilder() {
        this.annotation.options = IndexOptionsBuilder.indexOptionsBuilder().build();
        this.annotation.value = IndexDirection.ASC;
    }

    public Indexed build() {
        IndexedAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static IndexedBuilder indexedBuilder() {
        return new IndexedBuilder();
    }

    public static IndexedBuilder indexedBuilder(Indexed source) {
        IndexedBuilder builder = new IndexedBuilder();
        builder.annotation.options = source.options();
        builder.annotation.value = source.value();
        return builder;
    }

    public IndexedBuilder options(IndexOptions options) {
        this.annotation.options = options;
        return this;
    }

    public IndexedBuilder value(IndexDirection value) {
        this.annotation.value = value;
        return this;
    }

    private static class IndexedAnnotation
    implements Indexed {
        private IndexOptions options;
        private IndexDirection value;

        private IndexedAnnotation() {
        }

        public Class<Indexed> annotationType() {
            return Indexed.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexedAnnotation)) {
                return false;
            }
            IndexedAnnotation that = (IndexedAnnotation)o;
            return Objects.equals(this.options, that.options) && Objects.equals((Object)this.value, (Object)that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.options, this.value});
        }

        @Override
        public IndexOptions options() {
            return this.options;
        }

        @Override
        public IndexDirection value() {
            return this.value;
        }
    }
}

