/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.Property;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class PropertyBuilder {
    private PropertyAnnotation annotation = new PropertyAnnotation();

    private PropertyBuilder() {
        this.annotation.concreteClass = Object.class;
        this.annotation.value = ".";
    }

    public Property build() {
        PropertyAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static PropertyBuilder propertyBuilder() {
        return new PropertyBuilder();
    }

    public static PropertyBuilder propertyBuilder(Property source) {
        PropertyBuilder builder = new PropertyBuilder();
        builder.annotation.concreteClass = source.concreteClass();
        builder.annotation.value = source.value();
        return builder;
    }

    public PropertyBuilder concreteClass(Class<?> concreteClass) {
        this.annotation.concreteClass = concreteClass;
        return this;
    }

    public PropertyBuilder value(String value) {
        this.annotation.value = value;
        return this;
    }

    private static class PropertyAnnotation
    implements Property {
        private Class<?> concreteClass;
        private String value;

        private PropertyAnnotation() {
        }

        public Class<Property> annotationType() {
            return Property.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyAnnotation)) {
                return false;
            }
            PropertyAnnotation that = (PropertyAnnotation)o;
            return Objects.equals(this.concreteClass, that.concreteClass) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.concreteClass, this.value);
        }

        @Override
        public Class<?> concreteClass() {
            return this.concreteClass;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

