/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.Reference;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class ReferenceBuilder {
    private ReferenceAnnotation annotation = new ReferenceAnnotation();

    private ReferenceBuilder() {
        this.annotation.idOnly = false;
        this.annotation.ignoreMissing = false;
        this.annotation.lazy = false;
        this.annotation.value = ".";
    }

    public Reference build() {
        ReferenceAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static ReferenceBuilder referenceBuilder() {
        return new ReferenceBuilder();
    }

    public static ReferenceBuilder referenceBuilder(Reference source) {
        ReferenceBuilder builder = new ReferenceBuilder();
        builder.annotation.idOnly = source.idOnly();
        builder.annotation.ignoreMissing = source.ignoreMissing();
        builder.annotation.lazy = source.lazy();
        builder.annotation.value = source.value();
        return builder;
    }

    public ReferenceBuilder idOnly(boolean idOnly) {
        this.annotation.idOnly = idOnly;
        return this;
    }

    public ReferenceBuilder ignoreMissing(boolean ignoreMissing) {
        this.annotation.ignoreMissing = ignoreMissing;
        return this;
    }

    public ReferenceBuilder lazy(boolean lazy) {
        this.annotation.lazy = lazy;
        return this;
    }

    public ReferenceBuilder value(String value) {
        this.annotation.value = value;
        return this;
    }

    private static class ReferenceAnnotation
    implements Reference {
        private boolean idOnly;
        private boolean ignoreMissing;
        private boolean lazy;
        private String value;

        private ReferenceAnnotation() {
        }

        public Class<Reference> annotationType() {
            return Reference.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReferenceAnnotation)) {
                return false;
            }
            ReferenceAnnotation that = (ReferenceAnnotation)o;
            return Objects.equals(this.idOnly, that.idOnly) && Objects.equals(this.ignoreMissing, that.ignoreMissing) && Objects.equals(this.lazy, that.lazy) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.idOnly, this.ignoreMissing, this.lazy, this.value);
        }

        @Override
        public boolean idOnly() {
            return this.idOnly;
        }

        @Override
        public boolean ignoreMissing() {
            return this.ignoreMissing;
        }

        @Override
        public boolean lazy() {
            return this.lazy;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

