/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.ShardKey;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.ShardKeyType;
import java.util.Objects;

@MorphiaInternal
public final class ShardKeyBuilder {
    private ShardKeyAnnotation annotation = new ShardKeyAnnotation();

    private ShardKeyBuilder() {
        this.annotation.type = ShardKeyType.RANGED;
    }

    public ShardKey build() {
        ShardKeyAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static ShardKeyBuilder shardKeyBuilder() {
        return new ShardKeyBuilder();
    }

    public static ShardKeyBuilder shardKeyBuilder(ShardKey source) {
        ShardKeyBuilder builder = new ShardKeyBuilder();
        builder.annotation.type = source.type();
        builder.annotation.value = source.value();
        return builder;
    }

    public ShardKeyBuilder type(ShardKeyType type) {
        this.annotation.type = type;
        return this;
    }

    public ShardKeyBuilder value(String value) {
        this.annotation.value = value;
        return this;
    }

    private static class ShardKeyAnnotation
    implements ShardKey {
        private ShardKeyType type;
        private String value;

        private ShardKeyAnnotation() {
        }

        public Class<ShardKey> annotationType() {
            return ShardKey.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShardKeyAnnotation)) {
                return false;
            }
            ShardKeyAnnotation that = (ShardKeyAnnotation)o;
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        @Override
        public ShardKeyType type() {
            return this.type;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

