/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.ShardOptions;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class ShardOptionsBuilder {
    private ShardOptionsAnnotation annotation = new ShardOptionsAnnotation();

    private ShardOptionsBuilder() {
        this.annotation.numInitialChunks = -1;
        this.annotation.presplitHashedZones = false;
        this.annotation.unique = false;
    }

    public ShardOptions build() {
        ShardOptionsAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static ShardOptionsBuilder shardOptionsBuilder() {
        return new ShardOptionsBuilder();
    }

    public static ShardOptionsBuilder shardOptionsBuilder(ShardOptions source) {
        ShardOptionsBuilder builder = new ShardOptionsBuilder();
        builder.annotation.numInitialChunks = source.numInitialChunks();
        builder.annotation.presplitHashedZones = source.presplitHashedZones();
        builder.annotation.unique = source.unique();
        return builder;
    }

    public ShardOptionsBuilder numInitialChunks(int numInitialChunks) {
        this.annotation.numInitialChunks = numInitialChunks;
        return this;
    }

    public ShardOptionsBuilder presplitHashedZones(boolean presplitHashedZones) {
        this.annotation.presplitHashedZones = presplitHashedZones;
        return this;
    }

    public ShardOptionsBuilder unique(boolean unique) {
        this.annotation.unique = unique;
        return this;
    }

    private static class ShardOptionsAnnotation
    implements ShardOptions {
        private int numInitialChunks;
        private boolean presplitHashedZones;
        private boolean unique;

        private ShardOptionsAnnotation() {
        }

        public Class<ShardOptions> annotationType() {
            return ShardOptions.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShardOptionsAnnotation)) {
                return false;
            }
            ShardOptionsAnnotation that = (ShardOptionsAnnotation)o;
            return Objects.equals(this.numInitialChunks, that.numInitialChunks) && Objects.equals(this.presplitHashedZones, that.presplitHashedZones) && Objects.equals(this.unique, that.unique);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.numInitialChunks, this.presplitHashedZones, this.unique);
        }

        @Override
        public int numInitialChunks() {
            return this.numInitialChunks;
        }

        @Override
        public boolean presplitHashedZones() {
            return this.presplitHashedZones;
        }

        @Override
        public boolean unique() {
            return this.unique;
        }
    }
}

