/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Text;
import dev.morphia.annotations.internal.IndexOptionsBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class TextBuilder {
    private TextAnnotation annotation = new TextAnnotation();

    private TextBuilder() {
        this.annotation.options = IndexOptionsBuilder.indexOptionsBuilder().build();
        this.annotation.value = -1;
    }

    public Text build() {
        TextAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static TextBuilder textBuilder() {
        return new TextBuilder();
    }

    public static TextBuilder textBuilder(Text source) {
        TextBuilder builder = new TextBuilder();
        builder.annotation.options = source.options();
        builder.annotation.value = source.value();
        return builder;
    }

    public TextBuilder options(IndexOptions options) {
        this.annotation.options = options;
        return this;
    }

    public TextBuilder value(int value) {
        this.annotation.value = value;
        return this;
    }

    private static class TextAnnotation
    implements Text {
        private IndexOptions options;
        private int value;

        private TextAnnotation() {
        }

        public Class<Text> annotationType() {
            return Text.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextAnnotation)) {
                return false;
            }
            TextAnnotation that = (TextAnnotation)o;
            return Objects.equals(this.options, that.options) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.options, this.value);
        }

        @Override
        public IndexOptions options() {
            return this.options;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

