/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.annotations.internal;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import dev.morphia.annotations.Validation;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Objects;

@MorphiaInternal
public final class ValidationBuilder {
    private ValidationAnnotation annotation = new ValidationAnnotation();

    private ValidationBuilder() {
        this.annotation.level = ValidationLevel.STRICT;
        this.annotation.action = ValidationAction.ERROR;
    }

    public Validation build() {
        ValidationAnnotation anno = this.annotation;
        this.annotation = null;
        return anno;
    }

    public static ValidationBuilder validationBuilder() {
        return new ValidationBuilder();
    }

    public static ValidationBuilder validationBuilder(Validation source) {
        ValidationBuilder builder = new ValidationBuilder();
        builder.annotation.value = source.value();
        builder.annotation.level = source.level();
        builder.annotation.action = source.action();
        return builder;
    }

    public ValidationBuilder value(String value) {
        this.annotation.value = value;
        return this;
    }

    public ValidationBuilder level(ValidationLevel level) {
        this.annotation.level = level;
        return this;
    }

    public ValidationBuilder action(ValidationAction action) {
        this.annotation.action = action;
        return this;
    }

    private static class ValidationAnnotation
    implements Validation {
        private String value;
        private ValidationLevel level;
        private ValidationAction action;

        private ValidationAnnotation() {
        }

        public Class<Validation> annotationType() {
            return Validation.class;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValidationAnnotation)) {
                return false;
            }
            ValidationAnnotation that = (ValidationAnnotation)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.level, that.level) && Objects.equals(this.action, that.action);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.level, this.action);
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public ValidationLevel level() {
            return this.level;
        }

        @Override
        public ValidationAction action() {
            return this.action;
        }
    }
}

