/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.config;

import com.mongodb.lang.Nullable;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.DateStorage;
import dev.morphia.mapping.DiscriminatorFunction;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.NamingStrategy;
import dev.morphia.query.DefaultQueryFactory;
import dev.morphia.query.QueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecProvider;

public class ManualMorphiaConfig
implements MorphiaConfig {
    Boolean applyCaps;
    Boolean applyDocumentValidations;
    Boolean applyIndexes;
    Boolean autoImportModels;
    String database;
    Optional<CodecProvider> codecProvider;
    NamingStrategy collectionNaming;
    DateStorage dateStorage;
    DiscriminatorFunction discriminator;
    String discriminatorKey;
    Boolean enablePolymorphicQueries;
    Boolean ignoreFinals;
    List<String> packages;
    MapperOptions.PropertyDiscovery propertyDiscovery;
    NamingStrategy propertyNaming;
    QueryFactory queryFactory;
    Boolean storeEmpties;
    Boolean storeNulls;
    UuidRepresentation uuidRepresentation;

    public ManualMorphiaConfig() {
    }

    ManualMorphiaConfig(MorphiaConfig base) {
        this.autoImportModels = base.autoImportModels();
        this.applyCaps = base.applyCaps();
        this.applyDocumentValidations = base.applyDocumentValidations();
        this.applyIndexes = base.applyIndexes();
        this.codecProvider = base.codecProvider();
        this.collectionNaming = base.collectionNaming();
        this.database = base.database();
        this.dateStorage = base.dateStorage();
        this.discriminator = base.discriminator();
        this.discriminatorKey = base.discriminatorKey();
        this.enablePolymorphicQueries = base.enablePolymorphicQueries();
        this.ignoreFinals = base.ignoreFinals();
        this.packages = new ArrayList<String>(base.packages());
        this.propertyDiscovery = base.propertyDiscovery();
        this.propertyNaming = base.propertyNaming();
        this.queryFactory = base.queryFactory();
        this.storeEmpties = base.storeEmpties();
        this.storeNulls = base.storeNulls();
        this.uuidRepresentation = base.uuidRepresentation();
    }

    public static ManualMorphiaConfig configure() {
        return new ManualMorphiaConfig();
    }

    public static ManualMorphiaConfig configure(MorphiaConfig base) {
        return new ManualMorphiaConfig(base);
    }

    @Override
    public Boolean applyCaps() {
        return this.orDefault(this.applyCaps, Boolean.FALSE);
    }

    @Override
    public Boolean applyDocumentValidations() {
        return this.orDefault(this.applyDocumentValidations, Boolean.FALSE);
    }

    @Override
    public Boolean applyIndexes() {
        return this.orDefault(this.applyIndexes, Boolean.FALSE);
    }

    @Override
    public Boolean autoImportModels() {
        return this.orDefault(this.autoImportModels, Boolean.FALSE);
    }

    @Override
    public Optional<CodecProvider> codecProvider() {
        return this.orDefault(this.codecProvider, Optional.empty());
    }

    @Override
    public NamingStrategy collectionNaming() {
        return this.orDefault(this.collectionNaming, NamingStrategy.camelCase());
    }

    @Override
    public String database() {
        return this.orDefault(this.database, "morphia");
    }

    @Override
    public DateStorage dateStorage() {
        return this.orDefault(this.dateStorage, DateStorage.UTC);
    }

    @Override
    public DiscriminatorFunction discriminator() {
        return this.orDefault(this.discriminator, DiscriminatorFunction.simpleName());
    }

    @Override
    public String discriminatorKey() {
        return this.orDefault(this.discriminatorKey, "_t");
    }

    @Override
    public Boolean enablePolymorphicQueries() {
        return this.orDefault(this.enablePolymorphicQueries, Boolean.FALSE);
    }

    @Override
    public Boolean ignoreFinals() {
        return this.orDefault(this.ignoreFinals, Boolean.FALSE);
    }

    @Override
    public List<String> packages() {
        return this.orDefault(this.packages, List.of());
    }

    @Override
    public MapperOptions.PropertyDiscovery propertyDiscovery() {
        return this.orDefault(this.propertyDiscovery, MapperOptions.PropertyDiscovery.FIELDS);
    }

    @Override
    public NamingStrategy propertyNaming() {
        return this.orDefault(this.propertyNaming, NamingStrategy.identity());
    }

    @Override
    public QueryFactory queryFactory() {
        return this.orDefault(this.queryFactory, new DefaultQueryFactory());
    }

    @Override
    public Boolean storeEmpties() {
        return this.orDefault(this.storeEmpties, Boolean.FALSE);
    }

    @Override
    public Boolean storeNulls() {
        return this.orDefault(this.storeNulls, Boolean.FALSE);
    }

    @Override
    public UuidRepresentation uuidRepresentation() {
        return this.orDefault(this.uuidRepresentation, UuidRepresentation.STANDARD);
    }

    public String toString() {
        return String.format("MorphiaConfig{applyCaps=%s, applyDocumentValidations=%s, applyIndexes=%s, database='%s', codecProvider=%s, collectionNaming=%s, dateStorage=%s, discriminator=%s, discriminatorKey='%s', enablePolymorphicQueries=%s, ignoreFinals=%s, packages=%s, propertyDiscovery=%s, propertyNaming=%s, queryFactory=%s, storeEmpties=%s, storeNulls=%s, uuidRepresentation=%s}", new Object[]{this.applyCaps(), this.applyDocumentValidations(), this.applyIndexes(), this.database(), this.codecProvider(), this.collectionNaming(), this.dateStorage(), this.discriminator(), this.discriminatorKey(), this.enablePolymorphicQueries(), this.ignoreFinals(), this.packages(), this.propertyDiscovery(), this.propertyNaming(), this.queryFactory(), this.storeEmpties(), this.storeNulls(), this.uuidRepresentation()});
    }

    private <T> T orDefault(@Nullable T localValue, T defaultValue) {
        return localValue != null ? localValue : defaultValue;
    }
}

