/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.config;

import dev.morphia.annotations.PossibleValues;
import dev.morphia.annotations.internal.MorphiaExperimental;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.CodecConverter;
import dev.morphia.config.DiscriminatorFunctionConverter;
import dev.morphia.config.ManualMorphiaConfig;
import dev.morphia.config.NamingStrategyConverter;
import dev.morphia.config.QueryFactoryConverter;
import dev.morphia.mapping.DateStorage;
import dev.morphia.mapping.DiscriminatorFunction;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.NamingStrategy;
import dev.morphia.query.LegacyQueryFactory;
import dev.morphia.query.QueryFactory;
import dev.morphia.sofia.Sofia;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecProvider;
import org.slf4j.LoggerFactory;

@MorphiaExperimental
@ConfigMapping(prefix="morphia")
public interface MorphiaConfig {
    public static MorphiaConfig load() {
        return MorphiaConfig.load("META-INF/morphia-config.properties");
    }

    public static MorphiaConfig load(String path) {
        List configSources = PropertiesConfigSourceProvider.classPathSources((String)path, (ClassLoader)Thread.currentThread().getContextClassLoader());
        if (configSources.isEmpty()) {
            LoggerFactory.getLogger(MorphiaConfig.class).warn(Sofia.missingConfigFile(path, new Locale[0]));
            return new ManualMorphiaConfig();
        }
        return (MorphiaConfig)new SmallRyeConfigBuilder().addDefaultInterceptors().withMapping(MorphiaConfig.class).withSources((Collection)configSources).addDefaultSources().build().getConfigMapping(MorphiaConfig.class);
    }

    default public MorphiaConfig collectionNaming(NamingStrategy value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.collectionNaming = value;
        return newConfig;
    }

    @WithDefault(value="morphia")
    public String database();

    @WithDefault(value="false")
    public Boolean applyCaps();

    default public MorphiaConfig applyCaps(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.applyCaps = value;
        return newConfig;
    }

    @WithDefault(value="false")
    public Boolean applyDocumentValidations();

    default public MorphiaConfig applyDocumentValidations(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.applyDocumentValidations = value;
        return newConfig;
    }

    @WithDefault(value="false")
    public Boolean applyIndexes();

    default public MorphiaConfig applyIndexes(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.applyIndexes = value;
        return newConfig;
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    @WithConverter(value=CodecConverter.class)
    public Optional<CodecProvider> codecProvider();

    default public MorphiaConfig codecProvider(CodecProvider value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.codecProvider = Optional.of(value);
        return newConfig;
    }

    @WithDefault(value="camelCase")
    @PossibleValues(value={"camelCase", "identity", "kebabCase", "lowerCase", "snakeCase", "fqcn"})
    @WithConverter(value=NamingStrategyConverter.class)
    public NamingStrategy collectionNaming();

    default public MorphiaConfig database(String value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.database = value;
        return newConfig;
    }

    @WithDefault(value="utc")
    public DateStorage dateStorage();

    default public MorphiaConfig dateStorage(DateStorage value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.dateStorage = value;
        return newConfig;
    }

    @WithDefault(value="simpleName")
    @WithConverter(value=DiscriminatorFunctionConverter.class)
    @PossibleValues(value={"className", "lowerClassName", "lowerSimpleName", "simpleName", "fqcn"})
    public DiscriminatorFunction discriminator();

    default public MorphiaConfig discriminator(DiscriminatorFunction value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.discriminator = value;
        return newConfig;
    }

    @WithDefault(value="_t")
    public String discriminatorKey();

    default public MorphiaConfig discriminatorKey(String value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.discriminatorKey = value;
        return newConfig;
    }

    @WithDefault(value="false")
    public Boolean enablePolymorphicQueries();

    default public MorphiaConfig enablePolymorphicQueries(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.enablePolymorphicQueries = value;
        return newConfig;
    }

    @WithDefault(value="false")
    public Boolean ignoreFinals();

    default public MorphiaConfig ignoreFinals(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.ignoreFinals = value;
        return newConfig;
    }

    default public MorphiaConfig legacy() {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.dateStorage = DateStorage.SYSTEM_DEFAULT;
        newConfig.discriminatorKey = "className";
        newConfig.discriminator = DiscriminatorFunction.className();
        newConfig.collectionNaming = NamingStrategy.identity();
        newConfig.propertyNaming = NamingStrategy.identity();
        newConfig.queryFactory = new LegacyQueryFactory();
        return newConfig;
    }

    @WithDefault(value=".*")
    public List<String> packages();

    default public MorphiaConfig packages(List<String> value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        if (!value.isEmpty()) {
            newConfig.packages = new ArrayList<String>(value);
        }
        return newConfig;
    }

    @WithDefault(value="fields")
    @PossibleValues(value={"fields", "methods"}, fqcn=false)
    public MapperOptions.PropertyDiscovery propertyDiscovery();

    default public MorphiaConfig propertyDiscovery(MapperOptions.PropertyDiscovery value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.propertyDiscovery = value;
        return newConfig;
    }

    @WithDefault(value="identity")
    @WithConverter(value=NamingStrategyConverter.class)
    @PossibleValues(value={"camelCase", "identity", "kebabCase", "lowerCase", "snakeCase", "fqcn"})
    public NamingStrategy propertyNaming();

    default public MorphiaConfig propertyNaming(NamingStrategy value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.propertyNaming = value;
        return newConfig;
    }

    @WithConverter(value=QueryFactoryConverter.class)
    @WithDefault(value="dev.morphia.query.DefaultQueryFactory")
    public QueryFactory queryFactory();

    default public MorphiaConfig queryFactory(QueryFactory value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.queryFactory = value;
        return newConfig;
    }

    @WithDefault(value="false")
    public Boolean storeEmpties();

    default public MorphiaConfig storeEmpties(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.storeEmpties = value;
        return newConfig;
    }

    @WithDefault(value="false")
    public Boolean storeNulls();

    default public MorphiaConfig storeNulls(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.storeNulls = value;
        return newConfig;
    }

    @WithDefault(value="standard")
    @Deprecated(forRemoval=true, since="2.4.0")
    public UuidRepresentation uuidRepresentation();

    default public MorphiaConfig uuidRepresentation(UuidRepresentation value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.uuidRepresentation = value;
        return newConfig;
    }

    @MorphiaInternal
    @WithDefault(value="true")
    public Boolean autoImportModels();

    @MorphiaInternal
    @WithDefault(value="true")
    default public MorphiaConfig autoImportModels(Boolean value) {
        ManualMorphiaConfig newConfig = new ManualMorphiaConfig(this);
        newConfig.autoImportModels = value;
        return newConfig;
    }
}

