/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.config;

import dev.morphia.annotations.PossibleValues;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.annotations.internal.PossibleValuesBuilder;
import dev.morphia.config.MapperOptionsWrapper;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.NamingStrategy;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.Converter;

@MorphiaInternal
public class MorphiaConfigHelper {
    static final String MORPHIA_CONFIG_PROPERTIES = "META-INF/morphia-config.properties";
    final String prefix;
    private final MorphiaConfig config;
    private final boolean showComplete;
    private final List<Entry> entries;

    public static String dumpConfigurationFile(MapperOptions options, String database, boolean showComplete) {
        MapperOptionsWrapper wrapper = new MapperOptionsWrapper(options, database);
        MorphiaConfigHelper helper = new MorphiaConfigHelper(wrapper, showComplete);
        return helper.toString();
    }

    @MorphiaInternal
    public static String dumpConfigurationFile(MorphiaConfig config, boolean showComplete) {
        return new MorphiaConfigHelper(config, showComplete).toString();
    }

    MorphiaConfigHelper(MorphiaConfig config, boolean showComplete) {
        this.config = config;
        this.showComplete = showComplete;
        this.prefix = MorphiaConfigHelper.getPrefix();
        this.entries = Arrays.stream(MorphiaConfig.class.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName)).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> m.getParameterCount() == 0 && !m.getReturnType().equals(MorphiaConfig.class)).map(m -> this.getEntry(this.prefix, (Method)m)).collect(Collectors.toList());
    }

    public String toString() {
        return this.entries.stream().map(Entry::printEntry).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    private Entry getEntry(String prefix, Method m) {
        WithConverter annotation = m.getAnnotation(WithConverter.class);
        Converter converter = null;
        if (annotation != null) {
            try {
                converter = (Converter)annotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return new Entry(prefix + NamingStrategy.kebabCase().apply(m.getName()), Optional.class.isAssignableFrom(m.getReturnType()), this.getValue(m), this.getDefault(m), this.getPossibles(m), converter);
    }

    private static String getPrefix() {
        Object prefix = MorphiaConfig.class.getAnnotation(ConfigMapping.class).prefix();
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + ".";
        }
        return prefix;
    }

    private Object getValue(Method m) {
        try {
            Object invoke = m.invoke((Object)this.config, new Object[0]);
            return MorphiaConfigHelper.convertToString(invoke);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name().toLowerCase();
        }
        if (value instanceof Optional) {
            return MorphiaConfigHelper.convertToString(((Optional)value).orElse(null));
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof Boolean) {
            return value.toString().toLowerCase();
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return ".*";
            }
            StringJoiner joiner = new StringJoiner(",");
            for (Object o : list) {
                joiner.add(MorphiaConfigHelper.convertToString(o));
            }
            return joiner.toString();
        }
        return value.getClass().getName();
    }

    private PossibleValues getPossibles(Method m) {
        if (!m.getReturnType().isEnum()) {
            return m.getAnnotation(PossibleValues.class);
        }
        return PossibleValuesBuilder.possibleValuesBuilder().value((String[])Arrays.stream(m.getReturnType().getEnumConstants()).map(v -> (Enum)v).map(e -> e.name().toLowerCase()).toArray(String[]::new)).build();
    }

    private String getDefault(Method m) {
        WithDefault annotation = m.getAnnotation(WithDefault.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    private class Entry {
        String name;
        private final boolean optional;
        Object value;
        String defaultValue;
        PossibleValues possibleValues;
        Converter<?> converter;

        public Entry(String name, boolean optional, Object value, String defaultValue, PossibleValues possibleValues, Converter<?> converter) {
            this.name = name;
            this.value = value;
            this.defaultValue = defaultValue;
            this.possibleValues = possibleValues;
            this.converter = converter;
            this.optional = optional;
            this.normalize();
        }

        public String toString() {
            return this.name;
        }

        private void normalize() {
            if (this.possibleValues != null) {
                Arrays.stream(this.possibleValues.value()).filter(v1 -> {
                    String converted = this.converter != null ? MorphiaConfigHelper.convertToString(this.converter.convert(v1)) : v1;
                    return this.value.equals(converted);
                }).findFirst().ifPresent(v -> {
                    this.value = v;
                });
            }
        }

        String printEntry() {
            if (MorphiaConfigHelper.this.showComplete || this.value != null && !this.value.equals(this.defaultValue)) {
                StringJoiner joiner = new StringJoiner("\n");
                joiner.add("######");
                if (this.optional) {
                    joiner.add("# Optional");
                }
                if (!this.optional && this.defaultValue == null) {
                    joiner.add("# Required");
                }
                if (this.defaultValue != null) {
                    joiner.add("# default=" + this.defaultValue);
                }
                if (this.possibleValues != null) {
                    joiner.add("# possible values=" + String.join((CharSequence)", ", this.possibleValues.value()));
                }
                joiner.add("######");
                joiner.add(this.name + "=" + (this.value != null ? this.value : ""));
                return joiner.toString();
            }
            return null;
        }
    }
}

