/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.config;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.NamingStrategy;
import org.eclipse.microprofile.config.spi.Converter;

@MorphiaInternal
public class NamingStrategyConverter
implements Converter<NamingStrategy> {
    public NamingStrategy convert(String value) throws IllegalArgumentException, NullPointerException {
        try {
            switch (value) {
                case "camelCase": {
                    return NamingStrategy.camelCase();
                }
                case "identity": {
                    return NamingStrategy.identity();
                }
                case "kebabCase": {
                    return NamingStrategy.kebabCase();
                }
                case "lowerCase": {
                    return NamingStrategy.lowerCase();
                }
                case "snakeCase": {
                    return NamingStrategy.snakeCase();
                }
            }
            return (NamingStrategy)Class.forName(value).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }
}

