/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.internal;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public final class MorphiaInternals {
    private static final Logger LOG = LoggerFactory.getLogger(MorphiaInternals.class);
    private static final Map<DriverVersion, Boolean> versions = new HashMap<DriverVersion, Boolean>();
    private static Boolean proxyClassesPresent;

    private MorphiaInternals() {
    }

    public static boolean proxyClassesPresent() {
        if (proxyClassesPresent == null) {
            try {
                Class.forName("net.bytebuddy.implementation.InvocationHandlerAdapter");
                proxyClassesPresent = true;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Lazy loading impossible due to missing dependencies.");
                proxyClassesPresent = false;
            }
        }
        return proxyClassesPresent;
    }

    @Nullable
    public static <V> V tryInvoke(DriverVersion version, Supplier<V> block) {
        if (versions.get((Object)version) == null) {
            try {
                return block.get();
            }
            catch (NoSuchMethodError e) {
                versions.put(version, false);
            }
        }
        return null;
    }

    public static <V> V tryInvoke(DriverVersion version, Supplier<V> block, Supplier<V> fallback) {
        if (versions.get((Object)version) == null) {
            try {
                return block.get();
            }
            catch (NoSuchMethodError e) {
                versions.put(version, false);
            }
        }
        return fallback.get();
    }

    public static enum DriverVersion {
        v4_0_0,
        v4_1_0,
        v4_2_0,
        v4_6_0;

    }
}

