/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.internal;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.query.ValidationException;
import dev.morphia.sofia.Sofia;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;

@MorphiaInternal
public class PathTarget {
    private final List<String> segments;
    private final boolean validateNames;
    private int position;
    private final Mapper mapper;
    private final EntityModel root;
    private EntityModel context;
    private PropertyModel target;
    private boolean resolved;

    public PathTarget(Mapper mapper, EntityModel root, String path) {
        this(mapper, root, path, true);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PathTarget(Mapper mapper, @Nullable EntityModel root, String path, boolean validateNames) {
        this.segments = Arrays.asList(path.split("\\."));
        this.root = root;
        this.mapper = mapper;
        this.validateNames = validateNames;
        this.resolved = path.startsWith("$");
    }

    public <T> PathTarget(Mapper mapper, @Nullable Class<T> type, String path) {
        this(mapper, type != null && mapper.isMappable(type) ? mapper.getEntityModel(type) : null, path, true);
    }

    public <T> PathTarget(Mapper mapper, @Nullable Class<T> type, String path, boolean validateNames) {
        this(mapper, type != null && mapper.isMappable(type) ? mapper.getEntityModel(type) : null, path, validateNames);
    }

    public Mapper mapper() {
        return this.mapper;
    }

    public EntityModel root() {
        return this.root;
    }

    public String translatedPath() {
        if (!this.resolved) {
            this.resolve();
        }
        StringJoiner joiner = new StringJoiner(".");
        this.segments.forEach(joiner::add);
        return joiner.toString();
    }

    @Nullable
    public PropertyModel target() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.target;
    }

    public String toString() {
        return String.format("PathTarget{root=%s, segments=%s, target=%s}", this.root.getType().getSimpleName(), this.segments, this.target);
    }

    private boolean hasNext() {
        return this.position < this.segments.size();
    }

    private void failValidation(String pathElement) {
        this.resolved = true;
        throw new ValidationException(Sofia.invalidPathTarget(this.translatedPath(), this.root.getType().getName(), pathElement, new Locale[0]));
    }

    private void resolve() {
        this.context = this.root;
        this.position = 0;
        PropertyModel property = null;
        while (!this.resolved && this.hasNext()) {
            String segment = this.next();
            if ("$".equals(segment) || segment.startsWith("$[") && segment.endsWith("]") || segment.matches("[0-9]+")) {
                if (!this.hasNext()) break;
                segment = this.next();
            }
            if ((property = this.resolveProperty(segment)) != null) {
                if (this.hasNext() && property.isReference()) {
                    this.failValidation(segment);
                }
                this.translate(property.getMappedName());
                if (!property.isMap()) continue;
                this.resolved = true;
                continue;
            }
            if (!this.validateNames) continue;
            this.failValidation(segment);
        }
        this.target = property;
        this.resolved = true;
    }

    private void translate(String nameToStore) {
        this.segments.set(this.position - 1, nameToStore);
    }

    @Nullable
    private PropertyModel resolveProperty(String segment) {
        if (this.context != null) {
            PropertyModel model = this.context.getProperty(segment);
            if (model == null) {
                Iterator<EntityModel> subTypes = this.context.getSubtypes().iterator();
                while (model == null && subTypes.hasNext()) {
                    this.context = subTypes.next();
                    model = this.resolveProperty(segment);
                }
            }
            if (model != null) {
                try {
                    this.context = this.mapper.getEntityModel(model.getNormalizedType());
                }
                catch (NotMappableException ignored) {
                    this.context = null;
                }
            }
            return model;
        }
        return null;
    }

    String next() {
        return this.segments.get(this.position++);
    }
}

