/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;

public abstract class DiscriminatorFunction {
    public static DiscriminatorFunction className() {
        return new DiscriminatorFunction(){

            @Override
            public String compute(EntityModelBuilder builder) {
                return builder.type().getName();
            }
        };
    }

    public static DiscriminatorFunction lowerClassName() {
        return new DiscriminatorFunction(){

            @Override
            public String compute(EntityModelBuilder builder) {
                return builder.type().getName().toLowerCase();
            }
        };
    }

    public static DiscriminatorFunction lowerSimpleName() {
        return new DiscriminatorFunction(){

            @Override
            public String compute(EntityModelBuilder builder) {
                return builder.type().getSimpleName().toLowerCase();
            }
        };
    }

    public static DiscriminatorFunction simpleName() {
        return new DiscriminatorFunction(){

            @Override
            public String compute(EntityModelBuilder builder) {
                return builder.type().getSimpleName();
            }
        };
    }

    public final void apply(EntityModelBuilder builder) {
        String discriminator = ".";
        Entity entity = builder.getAnnotation(Entity.class);
        if (entity != null) {
            discriminator = entity.discriminator();
        } else {
            Embedded embedded = builder.getAnnotation(Embedded.class);
            if (embedded != null) {
                discriminator = embedded.discriminator();
            }
        }
        if (discriminator.equals(".")) {
            discriminator = this.compute(builder);
        }
        builder.discriminator(discriminator);
    }

    protected abstract String compute(EntityModelBuilder var1);
}

