/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.InstanceCreatorFactory;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.NoArgCreator;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.internal.ConstructorCreator;
import dev.morphia.sofia.Sofia;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class InstanceCreatorFactoryImpl
implements InstanceCreatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCreatorFactoryImpl.class);
    private final EntityModel model;
    private Supplier<MorphiaInstanceCreator> creator;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public InstanceCreatorFactoryImpl(EntityModel model) {
        this.model = model;
    }

    @Override
    public MorphiaInstanceCreator create() {
        if (this.creator == null) {
            if (!this.model.getType().isInterface()) {
                Constructor<?> constructor = ConstructorCreator.bestConstructor(this.model);
                if (constructor != null) {
                    this.creator = () -> new ConstructorCreator(this.model, constructor);
                } else {
                    LOG.info("using old creator approach: " + this.model.getType().getName());
                    try {
                        Constructor<?> declared = this.model.getType().getDeclaredConstructor(new Class[0]);
                        this.creator = () -> new NoArgCreator(declared);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor<?> full = ConstructorCreator.getFullConstructor(this.model);
                        this.creator = () -> new ConstructorCreator(this.model, full);
                    }
                }
            }
            if (this.creator == null) {
                throw new MappingException(Sofia.noSuitableConstructor(this.model.getType().getName(), new Locale[0]));
            }
        }
        return this.creator.get();
    }
}

