/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.lang.Nullable;
import dev.morphia.EntityListener;
import dev.morphia.Key;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.ExternalEntity;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.DiscriminatorLookup;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.references.MorphiaProxy;
import dev.morphia.mapping.validation.MappingValidator;
import dev.morphia.sofia.Sofia;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class Mapper {
    private static final Logger LOG = LoggerFactory.getLogger(Mapper.class);
    @MorphiaInternal
    public static final String IGNORED_FIELDNAME = ".";
    @MorphiaInternal
    public static final List<Class<? extends Annotation>> MAPPING_ANNOTATIONS = List.of(Entity.class, Embedded.class, ExternalEntity.class);
    @MorphiaInternal
    public static final List<Class<? extends Annotation>> LIFECYCLE_ANNOTATIONS = List.of(PrePersist.class, PreLoad.class, PostPersist.class, PostLoad.class);
    private final Map<String, EntityModel> mappedEntities = new ConcurrentHashMap<String, EntityModel>();
    private final ConcurrentHashMap<String, Set<EntityModel>> mappedEntitiesByCollection = new ConcurrentHashMap();
    private final List<EntityListener<?>> listeners = new ArrayList();
    private final MorphiaConfig config;
    private final DiscriminatorLookup discriminatorLookup;
    private final ClassLoader contextClassLoader;

    @MorphiaInternal
    public Mapper(MorphiaConfig config) {
        this.config = config;
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.discriminatorLookup = new DiscriminatorLookup();
    }

    public Mapper(Mapper other) {
        this.config = other.config;
        this.contextClassLoader = other.contextClassLoader;
        this.discriminatorLookup = new DiscriminatorLookup();
        other.mappedEntities.values().forEach(entity -> this.clone((EntityModel)entity));
        this.listeners.addAll(other.listeners);
    }

    @Nullable
    private EntityModel clone(@Nullable EntityModel original) {
        if (original == null) {
            return null;
        }
        if (this.isMapped(original.getType())) {
            return this.getEntityModel(original.getType());
        }
        EntityModel superClone = this.clone(original.superClass);
        if (superClone == null || superClone.getSubtype(original.getType()) == null) {
            EntityModel copy = this.register(new EntityModel(original), false);
            Set subtypes = original.subtypes.stream().map((? super T subtype) -> {
                EntityModel clonedSubtype = this.clone((EntityModel)subtype);
                clonedSubtype.superClass = copy;
                return clonedSubtype;
            }).collect(Collectors.toSet());
            copy.subtypes.addAll(subtypes);
        }
        return this.getEntityModel(original.getType());
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public void addInterceptor(EntityListener<?> ei) {
        this.listeners.add(ei);
    }

    public Mapper copy() {
        return new Mapper(this);
    }

    public MongoCollection enforceWriteConcern(MongoCollection collection, Class type) {
        WriteConcern applied = this.getWriteConcern(type);
        return applied != null ? collection.withWriteConcern(applied) : collection;
    }

    @MorphiaInternal
    public PropertyModel findIdProperty(Class<?> type) {
        EntityModel entityModel = this.getEntityModel(type);
        PropertyModel idField = entityModel.getIdProperty();
        if (idField == null) {
            throw new MappingException(Sofia.idRequired(type.getName(), new Locale[0]));
        }
        return idField;
    }

    @Nullable
    public <T> Class<T> getClass(Document document) {
        Class c = null;
        String discriminator = (String)document.get((Object)this.getConfig().discriminatorKey());
        if (discriminator != null) {
            c = this.getClass(discriminator);
        }
        return c;
    }

    public Class getClass(String discriminator) {
        return this.discriminatorLookup.lookup(discriminator);
    }

    @MorphiaInternal
    public <T> Class<T> getClassFromCollection(String collection) {
        List<EntityModel> classes = this.getClassesMappedToCollection(collection);
        if (classes.size() > 1) {
            LOG.warn(Sofia.moreThanOneMapper(collection, classes.stream().map((? super T c) -> c.getType().getName()).collect(Collectors.joining(", ")), new Locale[0]));
        }
        return classes.get(0).getType();
    }

    @MorphiaInternal
    public List<EntityModel> getClassesMappedToCollection(String collection) {
        Set<EntityModel> entities = this.mappedEntitiesByCollection.get(collection);
        if (entities == null || entities.isEmpty()) {
            throw new MappingException(Sofia.collectionNotMapped(collection, new Locale[0]));
        }
        return new ArrayList<EntityModel>(entities);
    }

    public DiscriminatorLookup getDiscriminatorLookup() {
        return this.discriminatorLookup;
    }

    @MorphiaInternal
    public EntityModel getEntityModel(Class type) {
        Class actual;
        Class clazz = actual = MorphiaProxy.class.isAssignableFrom(type) ? type.getSuperclass() : type;
        if (actual == null && MorphiaProxy.class.equals(type)) {
            throw new NotMappableException(type);
        }
        EntityModel model = this.mappedEntities.get(actual.getName());
        if (model == null) {
            if (!this.isMappable(actual)) {
                throw new NotMappableException(type);
            }
            model = this.register(new EntityModelBuilder(this, type).build());
        }
        return model;
    }

    @Nullable
    public Object getId(@Nullable Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            EntityModel model = this.getEntityModel(entity.getClass());
            PropertyModel idField = model.getIdProperty();
            if (idField != null) {
                return idField.getValue(entity);
            }
        }
        catch (NotMappableException notMappableException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public List<EntityListener<?>> getInterceptors() {
        return this.listeners;
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    public <T> Key<T> getKey(T entity) {
        if (entity instanceof Key) {
            return (Key)entity;
        }
        Object id = this.getId(entity);
        Class<?> aClass = entity.getClass();
        return id == null ? null : new Key(aClass, this.getEntityModel(aClass).getCollectionName(), id);
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    public <T> Key<T> getKey(T entity, String collection) {
        if (entity instanceof Key) {
            return (Key)entity;
        }
        Object id = this.getId(entity);
        Class<?> aClass = entity.getClass();
        return id == null ? null : new Key(aClass, collection, id);
    }

    public List<EntityModel> getMappedEntities() {
        return new ArrayList<EntityModel>(this.mappedEntities.values());
    }

    public MorphiaConfig getConfig() {
        return this.config;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public void setOptions(MapperOptions options) {
    }

    @Nullable
    public WriteConcern getWriteConcern(Class clazz) {
        Entity entityAnn;
        WriteConcern wc = null;
        EntityModel entityModel = this.getEntityModel(clazz);
        if (entityModel != null && (entityAnn = entityModel.getEntityAnnotation()) != null && !entityAnn.concern().isEmpty()) {
            wc = WriteConcern.valueOf((String)entityAnn.concern());
        }
        return wc;
    }

    public boolean hasInterceptors() {
        return !this.listeners.isEmpty();
    }

    public <T> boolean isMappable(Class<T> type) {
        Class<T> actual = MorphiaProxy.class.isAssignableFrom(type) ? type.getSuperclass() : type;
        return this.hasAnnotation(actual, MAPPING_ANNOTATIONS);
    }

    public boolean isMapped(Class c) {
        return this.mappedEntities.containsKey(c.getName());
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public List<EntityModel> map(Class ... entityClasses) {
        return this.map(List.of(entityClasses));
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public List<EntityModel> map(List<Class> classes) {
        Sofia.logConfiguredOperation("Mapper#map", new Locale[0]);
        for (Class type : classes) {
            if (this.isMappable(type)) continue;
            throw new MappingException(Sofia.mappingAnnotationNeeded(type.getName(), new Locale[0]));
        }
        return classes.stream().map(this::getEntityModel).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public synchronized void map(String packageName) {
        try {
            this.getClasses(this.contextClassLoader, packageName).forEach(type -> {
                try {
                    this.getEntityModel((Class)type);
                }
                catch (NotMappableException notMappableException) {
                    // empty catch block
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Could not get map classes from package " + packageName, e);
        }
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public synchronized void mapPackage(String packageName) {
        Sofia.logConfiguredOperation("Mapper#mapPackage", new Locale[0]);
        try {
            this.getClasses(this.contextClassLoader, packageName).forEach(type -> {
                try {
                    this.getEntityModel((Class)type);
                }
                catch (NotMappableException notMappableException) {
                    // empty catch block
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Could not get map classes from package " + packageName, e);
        }
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public void mapPackageFromClass(Class clazz) {
        this.mapPackage(clazz.getPackage().getName());
    }

    @Deprecated(since="2.0", forRemoval=true)
    public String updateCollection(Key key) {
        String collection = key.getCollection();
        Class type = key.getType();
        if (collection == null && type == null) {
            throw new IllegalStateException("Key is invalid! " + key);
        }
        if (collection == null) {
            collection = this.getEntityModel(type).getCollectionName();
            key.setCollection(collection);
        }
        return collection;
    }

    public void updateQueryWithDiscriminators(EntityModel model, Document query) {
        Entity annotation = model.getEntityAnnotation();
        if (annotation != null && annotation.useDiscriminator() && !query.containsKey((Object)"_id") && !query.containsKey((Object)model.getDiscriminatorKey())) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(model.getDiscriminator());
            if (this.config.enablePolymorphicQueries().booleanValue()) {
                for (EntityModel subtype : model.getSubtypes()) {
                    values.add(subtype.getDiscriminator());
                }
            }
            query.put(model.getDiscriminatorKey(), (Object)new Document("$in", values));
        }
    }

    @MorphiaInternal
    public EntityModel register(EntityModel entityModel) {
        return this.register(entityModel, true);
    }

    private EntityModel register(EntityModel entityModel, boolean validate) {
        this.discriminatorLookup.addModel(entityModel);
        this.mappedEntities.put(entityModel.getType().getName(), entityModel);
        this.mappedEntitiesByCollection.computeIfAbsent(entityModel.getCollectionName(), s -> new CopyOnWriteArraySet()).add(entityModel);
        EntityModel superClass = entityModel.getSuperClass();
        if (superClass != null) {
            superClass.addSubtype(entityModel);
        }
        if (validate && !entityModel.isInterface()) {
            new MappingValidator().validate(this, entityModel);
        }
        return entityModel;
    }

    private List<Class> getClasses(ClassLoader loader, String packageName) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        ClassGraph classGraph = new ClassGraph().addClassLoader(loader).enableAllInfo();
        if (packageName.endsWith(".*")) {
            String base = packageName.substring(0, packageName.length() - 2);
            if (!base.isEmpty()) {
                classGraph.acceptPackages(new String[]{base});
            }
            classGraph.acceptPackages(new String[]{packageName});
        } else {
            classGraph.acceptPackagesNonRecursive(new String[]{packageName});
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getAllClasses()) {
                try {
                    classes.add(Class.forName(classInfo.getName(), true, loader));
                }
                catch (Throwable throwable) {}
            }
        }
        return new ArrayList<Class>(classes);
    }

    private <T> boolean hasAnnotation(Class<T> clazz, List<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (clazz.getAnnotation(annotation) == null) continue;
            return true;
        }
        return clazz.getSuperclass() != null && this.hasAnnotation(clazz.getSuperclass(), annotations) || Arrays.stream(clazz.getInterfaces()).map((? super T i) -> this.hasAnnotation((Class)i, annotations)).reduce(false, (l, r) -> l != false || r != false) != false;
    }
}

