/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.DatastoreImpl;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

class ArrayCodec
implements Codec<Object> {
    private final Class<?> type;
    private DatastoreImpl datastore;

    <T> ArrayCodec(DatastoreImpl datastore, Class<T> type) {
        this.datastore = datastore;
        this.type = type;
    }

    public Object[] decode(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (reader.getCurrentBsonType() == BsonType.ARRAY) {
            reader.readStartArray();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                list.add(this.readValue(reader, decoderContext));
            }
            reader.readEndArray();
        } else {
            list.add(this.readValue(reader, decoderContext));
        }
        return list.toArray();
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        writer.writeStartArray();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(value, i);
            if (element == null) {
                writer.writeNull();
                continue;
            }
            Codec codec = this.datastore.getCodecRegistry().get(element.getClass());
            codec.encode(writer, element, encoderContext);
        }
        writer.writeEndArray();
    }

    public Class<Object> getEncoderClass() {
        return null;
    }

    @Nullable
    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.datastore.getCodecRegistry().get(UUID.class).decode(reader, decoderContext);
        }
        return this.datastore.getCodecRegistry().get(this.type.getComponentType()).decode(reader, decoderContext);
    }
}

