/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.FieldAccessor;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

@MorphiaInternal
public class ArrayFieldAccessor
extends FieldAccessor {
    private final TypeData<?> typeData;
    private final Class<?> componentType;

    public ArrayFieldAccessor(TypeData<?> typeData, Field field) {
        super(field);
        this.typeData = typeData;
        this.componentType = field.getType().getComponentType();
    }

    @Override
    public void set(Object instance, Object value) {
        Object newValue = value;
        if (value.getClass().getComponentType() != this.componentType) {
            newValue = value instanceof List ? this.convert((List)value) : this.convert((Object[])value);
        }
        super.set(instance, newValue);
    }

    private Object convert(Object[] value) {
        Object newArray = Array.newInstance(this.componentType, value.length);
        for (int i = 0; i < value.length; ++i) {
            Object convert = this.convert(value[i], this.componentType);
            Array.set(newArray, i, convert);
        }
        return newArray;
    }

    private Object convert(List value) {
        Object newArray = Array.newInstance(this.componentType, value.size());
        for (int i = 0; i < value.size(); ++i) {
            Object converted = this.convert(value.get(i), this.componentType);
            if (converted != null) {
                try {
                    Array.set(newArray, i, converted);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Can't set %s with a value type of %s", this.getField(), converted.getClass()));
                }
            }
            throw new IllegalArgumentException(String.format("Can not convert '%s' to type '%s' ", value.get(i), this.componentType.getName()));
        }
        return newArray;
    }

    @Nullable
    private Object convert(Object o, Class<?> type) {
        if (o instanceof List) {
            List list = (List)o;
            Object newArray = Array.newInstance(type.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object converted = this.convert(list.get(i), type.getComponentType());
                try {
                    Array.set(newArray, i, converted);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Can't set %s with a value type of %s", this.getField(), converted.getClass()));
                }
            }
            return newArray;
        }
        return Conversions.convert(o, type);
    }
}

