/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class BitSetCodec
implements Codec<BitSet> {
    private static final String LEGACY_ARRAY_KEY = "words";

    public void encode(BsonWriter writer, BitSet value, EncoderContext encoderContext) {
        writer.writeStartArray();
        long[] longs = value.toLongArray();
        for (int i = 0; i < longs.length; ++i) {
            writer.writeInt64(longs[i]);
        }
        writer.writeEndArray();
    }

    public BitSet decode(BsonReader reader, DecoderContext decoderContext) {
        BsonType currentType = reader.getCurrentBsonType();
        if (currentType == BsonType.DOCUMENT) {
            return this.decodeLegacy(reader, decoderContext);
        }
        if (currentType == BsonType.ARRAY) {
            return this.decodeModern(reader, decoderContext);
        }
        throw new IllegalStateException("cannot decode BitSet from " + currentType);
    }

    private BitSet decodeLegacy(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<Long> temp = new ArrayList<Long>();
        boolean foundKey = false;
        reader.readStartDocument();
        block4: while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            if (fieldName.equals(LEGACY_ARRAY_KEY)) {
                foundKey = true;
                reader.readStartArray();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    temp.add(reader.readInt64());
                }
                reader.readEndArray();
                continue;
            }
            switch (reader.getCurrentBsonType()) {
                case INT32: {
                    reader.readInt32();
                    continue block4;
                }
                case BOOLEAN: {
                    reader.readBoolean();
                    continue block4;
                }
            }
            throw new IllegalStateException("BitSetCodec can't decode field '" + fieldName + "' of type " + reader.getCurrentBsonType());
        }
        reader.readEndDocument();
        if (!foundKey) {
            throw new IllegalStateException("Expected BitSet BSON to contain a field named 'words', but not found!");
        }
        return BitSet.valueOf(BitSetCodec.toArray(temp));
    }

    private BitSet decodeModern(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<Long> temp = new ArrayList<Long>();
        reader.readStartArray();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            temp.add(reader.readInt64());
        }
        reader.readEndArray();
        return BitSet.valueOf(BitSetCodec.toArray(temp));
    }

    private static long[] toArray(List<Long> list) {
        long[] ret = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public Class<BitSet> getEncoderClass() {
        return BitSet.class;
    }
}

