/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import org.bson.BsonBinary;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class ByteWrapperArrayCodec
implements Codec<Byte[]> {
    public Byte[] decode(BsonReader reader, DecoderContext decoderContext) {
        return this.wrapper(reader.readBinaryData().getData());
    }

    public void encode(BsonWriter writer, Byte[] value, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(this.primitive(value)));
    }

    public Class<Byte[]> getEncoderClass() {
        return Byte[].class;
    }

    private byte[] primitive(Byte[] value) {
        byte[] array = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) continue;
            array[i] = value[i];
        }
        return array;
    }

    private Byte[] wrapper(byte[] value) {
        Byte[] array = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            array[i] = value[i];
        }
        return array;
    }
}

