/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.annotations.internal.MorphiaInternal;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class EnumCodec<T extends Enum<T>>
implements Codec<T> {
    private final Class<T> type;

    public EnumCodec(Class<T> type) {
        this.type = type;
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        writer.writeString(((Enum)value).name());
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return Enum.valueOf(this.type, reader.readString());
    }

    public Class<T> getEncoderClass() {
        return this.type;
    }
}

