/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.MappingException;
import java.lang.reflect.Field;
import org.bson.codecs.pojo.PropertyAccessor;

@MorphiaInternal
public class FieldAccessor
implements PropertyAccessor<Object> {
    private final Field field;

    public FieldAccessor(Field field) {
        this.field = field;
        field.setAccessible(true);
    }

    protected Field getField() {
        return this.field;
    }

    @Nullable
    public Object get(@Nullable Object instance) {
        try {
            return instance != null ? this.field.get(instance) : null;
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    public void set(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }
}

