/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import java.util.Iterator;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

@Deprecated(since="2.0", forRemoval=true)
public class KeyCodec
implements Codec<Key> {
    private Datastore datastore;

    KeyCodec(Datastore datastore) {
        this.datastore = datastore;
    }

    public Key decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        String ref = reader.readString("$ref");
        reader.readName();
        BsonReaderMark mark = reader.getMark();
        Object idValue = null;
        EntityModel model = null;
        Iterator<EntityModel> iterator = this.datastore.getMapper().getClassesMappedToCollection(ref).iterator();
        while (idValue == null && iterator.hasNext()) {
            model = iterator.next();
            try {
                PropertyModel idField = model.getIdProperty();
                if (idField == null) continue;
                Class<?> idType = idField.getType();
                idValue = this.datastore.getCodecRegistry().get(idType).decode(reader, decoderContext);
            }
            catch (Exception e) {
                mark.reset();
            }
        }
        if (idValue == null) {
            throw new MappingException("Could not map the Key to a type.");
        }
        reader.readEndDocument();
        return new Key(model.getType(), ref, idValue);
    }

    public Class<Key> getEncoderClass() {
        return Key.class;
    }

    public void encode(BsonWriter writer, Key value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            String collection = value.getCollection();
            if (collection == null) {
                collection = this.datastore.getMapper().getEntityModel(value.getType()).getCollectionName();
            }
            writer.writeString("$ref", collection);
            writer.writeName("$id");
            Codec codec = this.datastore.getCodecRegistry().get(value.getId().getClass());
            codec.encode(writer, value.getId(), encoderContext);
        });
    }
}

